import React from 'react';
import { Virtuoso } from 'react-virtuoso';
import AutoSizer from 'react-virtualized-auto-sizer';
import { NodeData } from '../TreeView.types';
import { ListProps } from './List.types';
import css from './List.module.css';

export const List = <TData extends NodeData>({ ItemComponent, ...restProps }: ListProps<TData>) => {
  const { treeTraversal } = restProps;

  return (
    <div className={css.List} data-testid="tree-view-list">
      <AutoSizer>
        {({ height, width }) => (
          <Virtuoso
            style={{ height, width }}
            initialItemCount={process.env.NODE_ENV === 'test' ? 10 : undefined}
            totalCount={treeTraversal.length}
            itemContent={(index) =>
              treeTraversal[index] && <ItemComponent {...treeTraversal[index]} {...restProps} />
            }
          />
        )}
      </AutoSizer>
    </div>
  );
};
