import React, { FC } from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Icon from '@crm/components/dist/lego2/Icon';
import { SearchComponentProps } from '../TreeView.types';
import css from './Search.module.css';

export const Search: FC<SearchComponentProps<string>> = React.memo(({ query, setQuery }) => {
  return (
    <div className={css.Search} data-testid="tree-view-search">
      <Textinput
        placeholder="Поиск"
        value={query}
        onChange={setQuery}
        hasClear={Boolean(query)}
        iconRight={
          query ? undefined : <Icon className={css.Search__icon} svg="loupe" svgSize="ml" />
        }
        autoFocus
      />
    </div>
  );
});
