import React, { FC, useCallback, useMemo } from 'react';

import Tags from 'lego/components/Tags';
import cx from 'classnames';

import { Bubble } from 'components/Bubble';
import { SelectedItemProps } from './SelectedBlock.types';
import { NodeData, SelectedBlockProps } from '../TreeView.types';
import css from './SelectedBlock.module.css';

export const SelectedItem: FC<SelectedItemProps> = ({ className, ...otherProps }) => {
  const {
    item: {
      data: { label },
    },
  } = otherProps;

  return (
    <Bubble {...otherProps} className={cx(className, css.SelectedItem)} canDelete>
      {label}
    </Bubble>
  );
};

const getKey = ({ data: { label } }) => label;

export const SelectedBlock = <TData extends NodeData>({
  selected,
  onSelectToggle,
  treeDictionary,
}: SelectedBlockProps<TData>) => {
  const handleDelete = useCallback(
    (_, { id }) => {
      onSelectToggle(id);
    },
    [onSelectToggle],
  );

  const items = useMemo(() => selected.map((id) => treeDictionary[id!]).toArray(), [
    selected,
    treeDictionary,
  ]);

  return (
    <div className={css.SelectedWrapper} data-testid="tree-view-selected-block">
      <Tags
        className={css.SelectedBlock}
        component={SelectedItem}
        items={items}
        getKey={getKey}
        onDelete={handleDelete}
      />
    </div>
  );
};
