import React from 'react';
import { Search } from '../Search';
import { List } from '../List';
import css from './Tree.module.css';
import { SelectedBlock } from '../SelectedBlock';
import { ButtonsReset } from '../Buttons';
import { Item } from '../Item';

export const Tree = ({ children }) => {
  return (
    <div data-testid="tree-view" className={css.Tree}>
      {children}
    </div>
  );
};

Tree.List = List;
Tree.Item = Item;
Tree.SelectedBlock = SelectedBlock;
Tree.Search = Search;
Tree.Buttons = ButtonsReset;
