import { ComponentType } from 'react';
import { Set } from 'immutable';

export type SearchExpandBehavior = 'keepExpanded' | 'expandOnce' | 'none';

export interface NodeData {
  label: string;
}

// FIXME: CRM-16054 придумать, как не сваливать в кучу все возможные доп поля,
//  которые могут появиться после фильтрации
export interface TreeNode<TData extends NodeData> {
  id: string;
  items?: TreeNode<TData>[];
  data: TData;
  // могут появиться после фильтрации
  searchMatchRange?: [number, number];
}

export type FlatTreeNode<TData extends NodeData> = Omit<TreeNode<TData>, 'items'> & {
  isLeaf: boolean;
  nestingLevel: number;
  isExpanded?: boolean;
};

export type TreeDictionary<TData extends NodeData> = Record<string, TreeNode<TData>>;

export interface TreeTraversal<TData extends NodeData> {
  treeTraversal: FlatTreeNode<TData>[];
}

export interface PredicateResult<TData extends NodeData> {
  isMatch: boolean;
  newNode: TreeNode<TData>;
}

export interface ItemComponentProps<TData extends NodeData> extends FlatTreeNode<TData> {
  onSelect: (id: string, isLeaf?: boolean) => void;
  onExpand: (id: string) => void;
  disableItemSelectionPredicate?: (node: FlatTreeNode<TData>) => boolean;
  getIsSelected: (id: string) => boolean;
}

export interface SearchComponentProps<TFilter> {
  query?: TFilter;
  setQuery: (query: TFilter) => void;
}

export interface SelectedBlockProps<TData extends NodeData> {
  selected: Set<string>;
  onSelectToggle: (id: string) => void;
  treeDictionary: TreeDictionary<TData>;
}

export interface ButtonsProps {
  savedSelected: Set<string>;
  currentSelected: Set<string>;
  onChange?: (selected: Set<string>) => void;
  onSave?: () => void;
}

export type Predicate<TData extends NodeData, TFilter> = (
  node: TreeNode<TData>,
  query: TFilter,
) => PredicateResult<TData>;

export interface BaseTreeViewProps<TData extends NodeData> {
  items: TreeNode<TData>[];
  showSelectedBlock?: boolean;
  SelectedBlock?: ComponentType<SelectedBlockProps<TData>>;
  showSearch?: boolean;
  showButtons?: boolean;
  defaultExpanded?: string[];
  expanded?: string[];
  onExpand?: (ids: string[]) => void;
  Buttons?: ComponentType<ButtonsProps>;
  searchExpandBehavior?: SearchExpandBehavior;
  ItemComponent?: ComponentType<ItemComponentProps<TData>>;
  /**
   * FIXME: CRM-16055 temp flag to switch to branch selection
   * this flag will possibly be unnecessary when branch selection strategy is ready
   */
  shouldSelectBranch?: boolean;
  defaultSelected?: string[];
  selected?: string[];
  onSave?: (ids: string[]) => void;
  onChange?: (ids: string[]) => void;
  singleSelect?: boolean;
  disableItemSelectionPredicate?: (node: FlatTreeNode<TData>) => boolean;
}

export interface TreeViewPropsDefaultSearch<TData extends NodeData>
  extends BaseTreeViewProps<TData> {
  search?: never;
}

export interface TreeViewPropsCustomSearch<TData extends NodeData, TFilter>
  extends BaseTreeViewProps<TData> {
  search: {
    SearchComponent: ComponentType<SearchComponentProps<TFilter>>;
    predicate: Predicate<TData, TFilter>;
  };
}

export type TreeViewProps<TData extends NodeData, TFilter = never> =
  | TreeViewPropsDefaultSearch<TData>
  | TreeViewPropsCustomSearch<TData, TFilter>;

export interface TreeViewComponentProps<TData extends NodeData, TFilter>
  extends BaseTreeViewProps<TData> {
  search: {
    SearchComponent: ComponentType<SearchComponentProps<TFilter>>;
    predicate: Predicate<TData, TFilter>;
  };
}
