import React, { useMemo } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon/Icon';
import { Text } from '@crm/components/dist/lego2/Text';
import { DEFAULT_LEFT_PADDING, NESTING_LEVEL_PADDING } from './FilterItem.config';
import css from './FilterItem.module.css';
import { FilterItemProps } from './FilterItem.types';

export const FilterItem: React.FC<FilterItemProps> = (props) => {
  const {
    id,
    isLeaf,
    nestingLevel,
    data,
    isSelected,
    isExpanded,
    onExpand,
    onSelect,
    disableItemSelectionPredicate,
  } = props;
  const { label, counter } = data;

  const isDisabled = useMemo(
    () => disableItemSelectionPredicate?.({ id, isLeaf, data, nestingLevel }),
    [data, disableItemSelectionPredicate, id, isLeaf, nestingLevel],
  );

  const style = useMemo(
    () => ({
      paddingLeft: `${DEFAULT_LEFT_PADDING + nestingLevel * NESTING_LEVEL_PADDING}px`,
    }),
    [nestingLevel],
  );

  const handleSelect = () => {
    if (!isDisabled) {
      onSelect(id, isLeaf);
    }
  };

  const handleExpand = () => {
    onExpand(id);
  };

  return (
    <div
      className={cx(css.FilterItem, {
        [css.FilterItem_selected]: isSelected,
        [css.FilterItem_disabled]: isDisabled,
        [css.FilterItem_expanded]: isExpanded,
        [css.FilterItem_leaf]: isLeaf,
      })}
      style={style}
    >
      <span
        className={css.FilterItem__expandIcon}
        data-hidden={isLeaf}
        data-testid="item-icon"
        onClick={handleExpand}
      >
        <Icon svg="arrowShort" svgSize="ms" />
      </span>
      <span onClick={handleSelect} className={css.FilterItem__label} title={label}>
        <Text typography="body-long-m" color={isDisabled ? 'secondary' : 'primary'}>
          {label}
        </Text>
      </span>
      <Text
        className={css.FilterItem__counter}
        typography="body-long-m"
        color={isDisabled ? 'secondary' : 'primary'}
        weight="medium"
      >
        {counter}
      </Text>
    </div>
  );
};
