import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';

class TreeNode extends React.Component {
  static propTypes = {
    collapsed: PropTypes.bool,
    defaultCollapsed: PropTypes.bool,
    forceOpen: PropTypes.bool,
    nodeLabel: PropTypes.node.isRequired,
    className: PropTypes.string,
    itemClassName: PropTypes.string,
    nodeLabelClass: PropTypes.string,
  };

  state = { collapsed: this.props.defaultCollapsed };

  handleClick = (...args) => {
    this.setState({ collapsed: !this.state.collapsed });
    if (this.props.onClick) {
      this.props.onClick(...args);
    }
  };

  open = () => {
    this.setState({ collapsed: false });
  };

  render() {
    const {
      collapsed = this.props.forceOpen ? false : this.state.collapsed,
      className = '',
      itemClassName = '',
      nodeLabel,
      children,
      nodeLabelClass,
      ...rest
    } = this.props;

    let arrowClassName = 'tree-view_arrow';
    let containerClassName = 'tree-view_children';
    if (collapsed) {
      arrowClassName += ' tree-view_arrow-collapsed';
      containerClassName += ' tree-view_children-collapsed';
    }

    return (
      <div className="tree-view">
        <div className={cx('tree-view_item', itemClassName)}>
          <span {...rest} onClick={this.handleClick} className={nodeLabelClass}>
            <div className={cx(className, arrowClassName)} />
            {nodeLabel}
          </span>
        </div>
        <div className={containerClassName}>{children}</div>
      </div>
    );
  }
}

export default TreeNode;
