import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import Select from 'components/Select';
import TreeNode from './TreeNode';
import styles from './style.js';
import './style.css';
import './react-treeview.css';

const propTypes = {
  // data: PropTypes.object,
  startLevel: PropTypes.number,
  isForceOpen: PropTypes.bool,
  canSelectAll: PropTypes.bool,
  selectedId: PropTypes.number,
  currentId: PropTypes.number,
  onItemClick: PropTypes.func,
};

export default class TreeView extends Component {
  render() {
    const { data } = this.props;
    const { itemCount } = this.props;
    const level = this.props.startLevel;

    return <div>{this.buildTreeView(this, data, itemCount, level)}</div>;
  }

  buildTreeView(context, items, itemCount, level = 0, parentPath = '') {
    if (!items || !items.length) {
      return;
    }

    const { onItemClick, selectedId, currentId, isForceOpen, canSelectAll } = context.props;

    return items.map((item) => {
      const { items } = item;

      const isSelect = selectedId === item.id;
      const isCurrent = currentId === item.id;

      item.fullPath = parentPath === '' ? item.name : `${parentPath} - ${item.name}`;
      if (!(items || (item.type !== undefined && item.type === 0))) {
        const isUnvailable = item.type === 1 && item.availability === 0;

        const itemClass = `${cx('leaf', { active: selectedId === item.id })} ${styles.item({
          default: !isForceOpen && !isSelect && !(isUnvailable && !canSelectAll),
          current: isCurrent,
          searching: isForceOpen && !isSelect && !(isUnvailable && !canSelectAll),
          selected: isSelect && !isCurrent && !(isUnvailable && !canSelectAll),
          unavaible: isUnvailable && !canSelectAll,
        })}`;

        if (isUnvailable) {
          if (canSelectAll) {
            return (
              <div
                key={item.id}
                className={itemClass}
                onClick={() => {
                  onItemClick(item);
                }}
                title="Сегодня отсутствует"
              >
                <Select
                  value={item.name}
                  range={item.select}
                  selectClass={styles.common('select')}
                />
                <i className="material-icons">do_not_disturb_alt</i>
              </div>
            );
          }
          return (
            <div key={item.id} className={itemClass} title="Сегодня отсутствует">
              <Select value={item.name} range={item.select} selectClass={styles.common('select')} />
              <i className="material-icons">do_not_disturb_alt</i>
            </div>
          );
        }
        return (
          <div
            key={item.id}
            className={itemClass}
            onClick={() => {
              onItemClick(item);
            }}
          >
            <span>
              <Select value={item.name} range={item.select} selectClass={styles.common('select')} />
              {item.counter ? ' ' : null}
              {item.counter ? (
                <span className={styles.common('count')}>({item.counter.total})</span>
              ) : null}
            </span>
          </div>
        );
      }
      const label = (
        <span>
          <Select value={item.name} range={item.select} selectClass={styles.common('select')} />
          {item.counter ? ' ' : null}
          {item.counter ? (
            <span className={styles.common('count')}>({item.counter.total})</span>
          ) : null}
        </span>
      );

      return (
        <TreeNode
          key={item.id}
          nodeLabel={label}
          defaultCollapsed={level !== 0}
          forceOpen={isForceOpen}
          nodeLabelClass={styles.folder({
            default: !isForceOpen,
            search: isForceOpen,
          })}
        >
          {context.buildTreeView(context, items, itemCount, level + 1, item.fullPath)}
        </TreeNode>
      );
    });
  }
}

TreeView.propTypes = propTypes;
