import { createContext } from 'react'
import { makeAutoObservable } from 'mobx';
import { LogEvent, LogEventTarget } from 'components/UXLogger';

export class EventAnchorService {
  public elemetAnchors = new Map<HTMLElement, LogEventTarget[]>()
  public anchorPath: LogEventTarget[];

  public constructor() {
    makeAutoObservable(this);
  }

  public getAdditionalPath = (path: LogEventTarget[]) => {
    let additionalPath: LogEventTarget[] = [];

    this.elemetAnchors.forEach((elPath, element) => {  
      if(!additionalPath.length && path.includes(element as LogEventTarget)){
        additionalPath = elPath;
      }
    })

    return additionalPath;
  }

  public setAnchor = (event: LogEvent) => {
    this.anchorPath = event.composedPath() as LogEventTarget[];
  }

  public setElement = (element: HTMLElement) => {
    if(this.anchorPath) {
      const additionalPath = this.getAdditionalPath(this.anchorPath)

      const newMap = new Map(this.elemetAnchors);
      newMap.set(element, this.anchorPath.concat(additionalPath))
      this.elemetAnchors = newMap
    }
  }

  public removeElement = (modal: HTMLElement) => {
      const newMap = new Map(this.elemetAnchors);
      newMap.delete(modal)
      this.elemetAnchors = newMap
  }
}

export const EventAnchorContext = createContext<EventAnchorService | undefined>(undefined)

