export interface LogEventTarget extends EventTarget {
  tagName: string;
  dataset?: Record<string, string>;
  className?: string;
}

export interface LogEvent extends Event {
  target: LogEventTarget | null;
  detail: number | CustomEventDetail;
}

export interface LogAdditionals {
  details?: unknown;
  testIdPath?: string[];
  unstableTestIdPath?: string[];
}

export interface CustomEventDetail {
  type: string;
  additionals: LogAdditionals;
}

export interface UXLogData {
  eventType: string;
  testIdPath: string[];
  unstableTestIdPath: string[];
  eventTimestamp: number;
  details: unknown;
}
