import { logger } from 'services/Logger';
import { UXLog, CUSTOM_EVENT_TYPE, TESTID_NAME, UNSTTABLE_TESTID_NAME } from './UXLogger.config';
import {
  LogEventTarget,
  LogEvent,
  UXLogData,
  CustomEventDetail,
  LogAdditionals,
} from './UXLogger.types';

export const getElementAttribute = (element: LogEventTarget | null, attribute: string) =>
  element?.dataset?.[attribute];

export const getEventType = (event: LogEvent) => event.type;

export const getEventAttributePath = (path: LogEventTarget[], attribute: string) => {
  return path.reduce((acc, element) => {
    const elementName = getElementAttribute(element, attribute);
    if (elementName) {
      acc.push(elementName);
    }

    return acc;
  }, [] as string[]);
};

export const makeDataFromEvent = (event: LogEvent, additionals?: LogAdditionals) => {
  const eventType = getEventType(event) || '';
  const testIdPath = getEventAttributePath(event.composedPath() as LogEventTarget[], TESTID_NAME);
  const unstableTestIdPath = getEventAttributePath(
    event.composedPath() as LogEventTarget[],
    UNSTTABLE_TESTID_NAME,
  );
  const eventTimestamp = Date.now();

  const {
    details,
    testIdPath: additionalTestIdPath = [],
    unstableTestIdPath: additionalUnstableTestIdPath = [],
  } = additionals || {};

  return {
    eventType,
    testIdPath: testIdPath.concat(additionalTestIdPath),
    unstableTestIdPath: unstableTestIdPath.concat(additionalUnstableTestIdPath),
    eventTimestamp,
    details,
  };
};

export const reportUxEvent = (data: UXLogData) => {
  if (process.env.NODE_ENV === 'production' || process.env.NODE_ENV === 'test') {
    logger.reportInfo(new UXLog('UXLog', data));
  }
};

export const dispatchUXEvent = (
  type: string,
  additionals: LogAdditionals = {},
  anchor?: EventTarget | HTMLElement | null,
) => {
  (anchor || window).dispatchEvent(
    new CustomEvent<CustomEventDetail>(CUSTOM_EVENT_TYPE, {
      detail: {
        type,
        additionals,
      },
      bubbles: true,
    }),
  );
};
