import { useEffect } from 'react';
import { config } from 'services/Config';
import { makeDataFromEvent, reportUxEvent } from '../UXLogger.utils';
import { LogEvent } from '../UXLogger.types';
import { UXEvent } from './useUXLogger.types';

export const useUXLogger = (events: UXEvent[]) => {
  const handleEvent = (event: LogEvent) => {
    const details = events.find((e) => e.type === event.type)?.details?.(event);
    const data = makeDataFromEvent(event, { details });
    reportUxEvent(data);
  };

  return useEffect(() => {
    if (config.value.features.newFrontendLogs) {
      events.forEach((event) => {
        const { element = window, type, callback = handleEvent } = event;
        element.addEventListener(type, callback);
      });

      return () => {
        events.forEach((event) => {
          const { element = window, type, callback = handleEvent } = event;
          element.removeEventListener(type, callback);
        });
      };
    }
  }, []);
};
