import { LogEvent } from '../UXLogger.types';
import { CUSTOM_EVENT_TYPE } from '../UXLogger.config';

export interface CustomEvent {
  element?: Window;
  type: typeof CUSTOM_EVENT_TYPE;
}

export interface WindowEvent {
  element?: Window;
  type: keyof WindowEventMap;
}

export interface DocumentEvent {
  element: Document;
  type: keyof DocumentEventMap;
}

export interface BaseEvent {
  callback?: (event: LogEvent) => void;
  details?: (event: LogEvent) => void;
}

export type UXEvent = BaseEvent & (WindowEvent | DocumentEvent | CustomEvent);
