import React from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { supportedBrowsers } from 'services/SupportedBrowsers';
import Link from '@crm/components/dist/lego2/Link';
import IconSvg from '@crm/components/dist/lego2/Icon/IconSvg';
import css from './UnsupportedBrowser.module.css';

export const UnsupportedBrowser: React.FC = () => {
  return (
    <div className={css.UnsupportedBrowser__wrapper} data-testid="unsupported-browser">
      <Text typography="subheader-m" weight="medium" className={css.UnsupportedBrowser__textBlock}>
        Ваш браузер не поддерживается или имеет устаревшую версию
      </Text>
      <Text
        typography="body-short-l"
        weight="medium"
        color="secondary"
        className={css.UnsupportedBrowser__textBlock}
      >
        Пожалуйста, установите один из следующих браузеров:
      </Text>
      <div className={css.UnsupportedBrowser__browsers}>
        {supportedBrowsers.map((browser) => (
          <div className={css.UnsupportedBrowser__browser} key={browser.name}>
            <IconSvg
              className={css.UnsupportedBrowser__logo}
              icon={browser.logo}
              width={120}
              height={120}
            />
            <Link href={browser.downloadLink} target="_blank">
              <Text typography="body-short-l" weight="medium" color="link">
                {browser.name}
              </Text>
            </Link>
            <Text typography="caption-l">{`версия ${browser.minimalVersion}+`}</Text>
          </div>
        ))}
      </div>
    </div>
  );
};
