import React, { useEffect } from 'react';
import { logger } from 'services/Logger';
import { UnsupportedComponentProps } from './UnsupportedComponent.types';

export const UnsupportedComponent: React.FC<UnsupportedComponentProps> = ({
  fallback,
  errorMessage = 'Unsupported component',
}) => {
  useEffect(() => {
    logger.reportError(new Error(errorMessage));
  }, []);

  return <>{fallback}</>;
};
