import React, { FC, memo } from 'react';
import Tags from 'lego/components/Tags';
import { UpsaleFactorComponent } from './UpsaleFactorComponent';
import { UpsaleFactorsComponentProps } from './types';

const getKey = (item) => item.id;

export const UpsaleFactorsComponent: FC<UpsaleFactorsComponentProps> = memo(({ factors }) => {
  if (!(Array.isArray(factors) && factors.length)) {
    return null;
  }

  return <Tags items={factors} getKey={getKey} component={UpsaleFactorComponent} />;
});
