import React, { FC, useRef } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { Bubble } from 'components/Bubble';
import ToolTip from 'lego/components/ToolTip';
import css from './UpsaleFactors2.module.css';
import { UpsaleFactors2Props } from './UpsaleFactors2.types';

export const UpsaleFactors2: FC<UpsaleFactors2Props> = (props) => {
  const { upsaleFactors, className } = props;
  const alignment = String(props.alignment || 'right').toLowerCase();
  const anchorRef = useRef<HTMLDivElement>(null);

  return (
    <ToolTip
      className={className}
      direction={alignment === 'right' ? ['left', 'right'] : ['right', 'left']}
      hideDelay={100}
      tooltip={
        <div className={css.UpsaleFactors__popup}>
          <Text typography="body-short-m">Upselling выполнен</Text>
          <div className={css.UpsaleFactors__popupFactors}>
            {upsaleFactors.map((upsale) => (
              <Bubble key={upsale.id} title={upsale.name}>
                <Text>{upsale.name}</Text>
              </Bubble>
            ))}
          </div>
        </div>
      }
    >
      <div ref={anchorRef} className={css.UpsaleFactors__button}>
        <Text color="inverse" weight="medium">
          $
        </Text>
      </div>
    </ToolTip>
  );
};
