import shallowEqual from 'utils/shallowEqual';

export interface FilterObj {
  // eslint-disable-next-line  @typescript-eslint/no-explicit-any
  [key: string]: any;
}

export type UpdateUrl = (search: string) => void;
export type UpdateFilterObj = (filter: FilterObj) => void;

// eslint-disable-next-line  @typescript-eslint/no-explicit-any
export type Parse = (filter: FilterObj) => any;
export type Format = (filter: FilterObj) => { [key: string]: string };

interface Props {
  updateUrl: UpdateUrl;
  updateFilterObj: UpdateFilterObj;
  parse: Parse;
  format: Format;
}

export class Filter {
  private lastSearch = '';

  private lastFilter: FilterObj | null = null;

  private props: Props;

  public constructor(props: Props) {
    this.props = props;
  }

  public set(search: URLSearchParams) {
    const filter = {};
    // @ts-ignore
    // eslint-disable-next-line no-restricted-syntax
    for (const pair of search.entries()) {
      // eslint-disable-next-line prefer-destructuring
      filter[pair[0]] = pair[1];
    }

    const parsedFilter = this.props.parse(filter);

    if (!shallowEqual(parsedFilter, filter)) {
      // обновляем фильтр в увле если он изменился после normalizeFilter
      this.updateUrl(parsedFilter);
    }

    if (!shallowEqual(parsedFilter, this.lastFilter)) {
      this.lastFilter = parsedFilter;
      this.props.updateFilterObj(parsedFilter);
    }
  }

  public compareSearch(search: string): boolean {
    return search === this.lastSearch;
  }

  public setFilter(filter: FilterObj) {
    this.lastFilter = filter;
    this.updateUrl(this.lastFilter);
  }

  public updateUrl(filter) {
    const query = new URLSearchParams(this.props.format(filter)).toString();

    if (query) {
      this.lastSearch = `?${query}`;
    } else {
      this.lastSearch = '';
    }

    this.props.updateUrl(this.lastSearch);
  }
}
