import { MouseEvent } from 'react';
import { User } from 'types/entities/user';
import { ExternalPassportUser } from 'types/ExternalPassportUser';
import { AvatarProps } from 'components/Avatar';

export interface UserLinkProps {
  className?: string;
  user: User | ExternalPassportUser;
  onClick?: (event: MouseEvent) => void;
  showCrmPosition?: boolean;
  showStatus?: boolean;
  showName?: boolean;
  isDisabled?: boolean;
  allowBreakWord?: boolean;
  isTooltipDisabled?: boolean;
  avatarProps?: Omit<AvatarProps, 'user'>;
}
