import React, { FC } from 'react';
import Tags from 'lego/components/Tags';
import color from 'color';
import { UserSkillWithValue } from 'types/UserSkill';
import { UserSkillsProps } from './UserSkills.types';

const coldColor = color('#A2C1E5');
const hotColor = color('#FE8181');

const skillValueToColorMap = Array(10)
  .fill(1)
  .reduce((ac, next, index) => {
    if (index === 0) {
      ac[index + 1] = coldColor.hex();
    } else {
      ac[index + 1] = coldColor.mix(hotColor, index / 9).hex();
    }
    return ac;
  }, {});

const getUserSkillKey = (userSkill: UserSkillWithValue) => userSkill.id;
const renderTagText = (userSkill: UserSkillWithValue) => `${userSkill.name} ${userSkill.value}`;
const getColor = (userSkill: UserSkillWithValue) => skillValueToColorMap[userSkill.value];

export const UserSkills: FC<UserSkillsProps> = ({ value, ...other }) => {
  return (
    <Tags
      render={renderTagText}
      getKey={getUserSkillKey}
      getColor={getColor}
      items={value}
      placeholder="—"
      {...other}
    />
  );
};
