import React, { FC } from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import { SkillAddMenu } from '../SkillAddMenu';
import { SkillAddProps } from './SkillAdd.types';

export const SkillAdd: FC<SkillAddProps> = (props) => {
  const { size, onAdd, userSkillsProviderFactory, setVisibility, visible, anchor } = props;

  const handleChange = (skill) => {
    setVisibility(false);
    onAdd?.(skill);
  };

  return (
    <Popup
      visible={visible}
      anchor={anchor}
      target="anchor"
      onOutsideClick={() => setVisibility(false)}
      keepMounted={false}
      style={{ width: 250, height: 250 }}
    >
      <SkillAddMenu
        size={size}
        onChange={handleChange}
        userSkillsProviderFactory={userSkillsProviderFactory}
      />
    </Popup>
  );
};
