import React, { FC, useCallback } from 'react';
import { FormByScheme, fixFieldNameInValues } from 'components/FormByScheme';
import { SkillSetupFormProps } from './SkillSetupForm.types';

const formConfig = {
  data: [
    {
      id: 'id',
      fields: [
        {
          id: 'skillValue',
          type: 'Select',
        },
      ],
    },
  ],
  meta: {
    fields: [
      {
        id: 'skillValue',
        title: 'Уровень',
        type: 'Select',
        access: 3,
        isFieldsUpdateNeeded: false,
        items: Array(10)
          .fill(1)
          .map((_, index) => String(index + 1))
          .map((value) => ({
            id: value,
            name: value,
          })),
      },
    ],
    fieldsVisibility: ['skillValue'],
  },
};

export const SkillSetupForm: FC<SkillSetupFormProps> = ({ onSubmit, ...other }) => {
  const handleSubmit = useCallback(
    (values, form) => {
      return onSubmit(fixFieldNameInValues(values, formConfig), form);
    },
    [onSubmit],
  );

  return (
    <FormByScheme title="Привязать сделку" scheme={formConfig} onSubmit={handleSubmit} {...other} />
  );
};
