import React, { useState } from 'react';
import { TestBed } from 'components/TestBed';
import { UserSkillsInput } from './UserSkillsInput';
import { UserSkillsProviderByCallback } from './UserSkillsProviderByCallback';

const userSkillsProviderStubFactory = () =>
  new UserSkillsProviderByCallback(() =>
    Promise.resolve(
      Array(100)
        .fill(1)
        .map((_, index) => ({ id: index, name: `Skill ${index}` })),
    ),
  );

export default {
  title: 'UserSkillsInput',
  component: UserSkillsInput,
};

export const Default = (args) => {
  const [value, setValue] = useState([
    { id: 1, name: 'skill1', value: 1 },
    { id: 2, name: 'skill2', value: 2 },
  ]);

  return (
    <TestBed>
      <UserSkillsInput
        {...args}
        value={value}
        onChange={setValue}
        userSkillsProviderFactory={userSkillsProviderStubFactory}
      />
    </TestBed>
  );
};

Default.args = {};
