import { UserSkillWithValue, UserSkill } from 'types/UserSkill';
import { UserSkillsProps } from 'components/UserSkills';
import { ArrayOperationAnyData } from 'types/ArrayOperation';
import { AsyncTaskStatus } from 'types/AsyncTaskStatus';

export interface UserSkillsProvider {
  error?: Error;
  status: AsyncTaskStatus;
  items: UserSkill[];
  load(text?: string): void;
  destroy(): void;
}

export type UserSkillsProviderFactory = () => UserSkillsProvider;

export interface UserSkillsInputProps extends UserSkillsProps {
  onChange?: (
    value: UserSkillWithValue[],
    operation: ArrayOperationAnyData<UserSkillWithValue>,
  ) => void;
  userSkillsProviderFactory?: UserSkillsProviderFactory;
}
