import { UserStatusId } from 'types/UserStatusId';
import { SvgIconType } from '@crm/components/dist/lego2/Icon';

export const USER_STATUS_ID_TO_ICON_TYPE: Record<UserStatusId, SvgIconType> = {
  [UserStatusId.unknown]: 'help',
  [UserStatusId.available]: 'checkCircle',
  [UserStatusId.workload]: 'busy',
  [UserStatusId.acw]: 'phoneLocked',
  [UserStatusId.sidework]: 'work',
  [UserStatusId.lunch]: 'freeBreakfast',
  [UserStatusId.shortbreak]: 'accessTime',
  [UserStatusId.meeting]: 'group',
  [UserStatusId.forcedPause]: 'pause',
  [UserStatusId.disconnected]: 'block',
} as const;

export const USER_STATUS_ID_TO_ICON_TYPE_MG: Record<UserStatusId, SvgIconType> = {
  [UserStatusId.unknown]: 'help2',
  [UserStatusId.available]: 'checkCircle2',
  [UserStatusId.workload]: 'busy2',
  [UserStatusId.acw]: 'phoneLocked2',
  [UserStatusId.sidework]: 'work2',
  [UserStatusId.lunch]: 'freeBreakfast2',
  [UserStatusId.shortbreak]: 'accessTime2',
  [UserStatusId.meeting]: 'group2',
  [UserStatusId.forcedPause]: 'pause2',
  [UserStatusId.disconnected]: 'block2',
} as const;

export const STATUS_COLOR_MG_MAP: Record<string, string> = {
  '#555': '#9397AD',
  '#555555': '#9397AD',
  '#ff0000ff': '#FF4D4D',
  '#ff0000': '#FF4D4D',
  '#ff0': '#FF4D4D',
  '#808080ff': '#9397AD',
  '#808080': '#9397AD',
};
