import React, { FC } from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import { UserStatusId } from 'types/UserStatusId';
import { UserStatusIconProps } from './UserStatusIcon.types';
import {
  USER_STATUS_ID_TO_ICON_TYPE,
  USER_STATUS_ID_TO_ICON_TYPE_MG,
  STATUS_COLOR_MG_MAP,
} from './UserStatusIcon.config';
import css from './UserStatusIcon.module.css';

export const UserStatusIcon: FC<UserStatusIconProps> = ({
  status,
  className,
  view = 'default',
}) => {
  const map = view === 'default' ? USER_STATUS_ID_TO_ICON_TYPE : USER_STATUS_ID_TO_ICON_TYPE_MG;
  let icon = map[status.id];

  if (!icon) {
    icon = map[UserStatusId.unknown];
  }

  const color =
    view === 'mg' && STATUS_COLOR_MG_MAP[status.color]
      ? STATUS_COLOR_MG_MAP[status.color]
      : status.color;

  return (
    <span className={className} title={status.text}>
      <Icon style={{ color }} svg={icon} className={css.UserStatusIcon__icon} />
    </span>
  );
};
