import React, { FC } from 'react';
import { observer } from 'mobx-react-lite';
import { UserStatusIcon } from 'components/UserStatusIcon';
import { userStatusStore } from 'services/UserStatus';
import { UserStatusIconByUserProps } from './UserStatusIconByUser.types';

export const UserStatusIconByUser: FC<UserStatusIconByUserProps> = observer(
  ({ userId, ...other }) => {
    const status = userStatusStore.getUserStatusById(userId);

    return <UserStatusIcon status={status.status} {...other} />;
  },
);
