import React, { PureComponent } from 'react';
import Select from 'components/Select';
import { AvailableLeafNodeProps } from './AvailableLeafNode.types';
import css from './AvailableLeafNode.module.css';

export default class AvailableLeafNode extends PureComponent<AvailableLeafNodeProps> {
  render() {
    const { item, ClassName, onClick } = this.props;
    return (
      <div className={ClassName} onClick={onClick}>
        <Select
          className={css.b__selectSpan}
          value={item.name}
          range={item.select}
          selectClass={css.b__selectSpanSelection}
        />
        {item.counter && item.counter.total && (
          <>
            &nbsp;
            <span className={css.b__count}>({item.counter.total})</span>
          </>
        )}
      </div>
    );
  }
}
