import React, { PureComponent } from 'react';
import cx from 'classnames';
import { LeafNodeProps } from './LeafNode.types';
import UnavailableLeafNode from './UnavailableLeafNode';
import AvailableLeafNode from './AvailableLeafNode';
import css from './LeafNode.module.css';

export default class LeafNode extends PureComponent<LeafNodeProps> {
  private onItemClick = () => {
    this.props.onItemClick(this.props.item);
  };

  private getClasses = (
    item,
    { isSelect, isForceOpen, isUnavailable, canSelectAll, isCurrent },
  ) => {
    return `${cx(css.b, css.b_commonFontStyle, {
      [css.b_default]: !isForceOpen && !isSelect && !(isUnavailable && !canSelectAll),
      [css.b_current]: isCurrent,
      [css.b_searching]: isForceOpen && !isSelect && !(isUnavailable && !canSelectAll),
      [css.b_selected]: isSelect && !isCurrent && !(isUnavailable && !canSelectAll),
    })}`;
  };

  render() {
    const { item, flags } = this.props;
    const ClassName = this.getClasses(item, flags);

    if (flags.isUnavailable) {
      return (
        <UnavailableLeafNode
          onClick={this.onItemClick}
          item={item}
          canSelectAll={flags.canSelectAll}
          ClassName={ClassName}
        />
      );
    }
    return <AvailableLeafNode onClick={this.onItemClick} item={item} ClassName={ClassName} />;
  }
}
