import React, { PureComponent } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import Select from 'components/Select';
import { UnavailableTreeNodeProps } from './UnavailableTreeNode.types';
import css from './UnavailableTreeNode.module.css';

const hintTitle = 'Сегодня отсутствует';

export default class UnavailableTreeNode extends PureComponent<UnavailableTreeNodeProps> {
  render() {
    const { item, canSelectAll, ClassName, onClick } = this.props;
    const otherProps = canSelectAll ? { onClick: onClick } : {};
    return (
      <div key={item.id} className={cx(css.b, ClassName)} title={hintTitle} {...otherProps}>
        <Select value={item.name} range={item.select} selectClass={css.b__selectSpanSelection} />
        <Icon className={css.b__icon} size="m" svg="block" />
      </div>
    );
  }
}
