import React, { PureComponent } from 'react';
import cx from 'classnames';
import Select from 'components/Select';
import css from './Node.module.css';
import { NodeProps } from './Node.types';

export default class Node extends PureComponent<NodeProps> {
  render() {
    const { data, isOpen, toggle } = this.props;
    const { item, flags } = data;

    return (
      <div
        className={cx(css.b, css.b_commonFontStyle, {
          [css.b_view_search]: flags.isForceOpen,
        })}
        onClick={!flags.isForceOpen ? toggle : undefined}
      >
        <div className={cx(css.b__arrow, { [css.b__arrow__collapsed]: !isOpen })} />
        <Select value={item.name} range={item.select} selectClass={css.b__selectSpanSelection} />
        {item.counter && item.counter.total && (
          <>
            &nbsp;
            <span className={css.b__count}>({item.counter.total})</span>
          </>
        )}
      </div>
    );
  }
}
