import React, { PureComponent } from 'react';
import LeafNode from './LeafNode';
import Node from './Node';
import { TreeNodeProps } from './TreeNode.types';
import { PADDING_SIZE } from '../VTreeView.constants';

export default class TreeNode extends PureComponent<TreeNodeProps> {
  render() {
    const { data, isOpen, style, toggle } = this.props;
    const { item, selectedId, onItemClick, flags } = data;

    const { height } = data;
    if (height !== style.height) {
      this.props.resize(height, true);
    }

    const extendsStyle = {
      ...style,
      width: data.width,
      marginLeft: `${data.nestingLevel * PADDING_SIZE}px`,
    };
    return (
      <div style={extendsStyle}>
        {!data.isLeaf ? (
          <Node item={item} isOpen={isOpen} data={data} toggle={toggle} />
        ) : (
          <LeafNode onItemClick={onItemClick} flags={flags} item={item} selectedId={selectedId} />
        )}
      </div>
    );
  }
}
