import React, { Component, RefObject } from 'react';
import { VariableSizeTree } from 'react-vtree';
import TreeNode from './TreeNode';
import getWalker from './utils/getWalker';
import { DataFromWalker } from './utils/getWalker/types';
import { VTreeViewProps } from './VTreeView.types';
import css from './VTreeView.module.css';
import getSizeDetector, { SizeDetector, SizeDetectorCache } from './utils/sizeDetector';

export default class VTreeView extends Component<VTreeViewProps> {
  private readonly treeRef: RefObject<VariableSizeTree<DataFromWalker>>;
  private readonly sizeDetectBox: HTMLDivElement;
  private sizeDetectBoxCache: SizeDetectorCache;
  private sizeDetector: SizeDetector;
  constructor(props) {
    super(props);
    this.treeRef = React.createRef();
    this.sizeDetectBox = document.createElement('div');
    this.sizeDetectBox.classList.add(css.sizeDetectBox);
    document.body.appendChild(this.sizeDetectBox);
    this.sizeDetectBoxCache = {};
    this.sizeDetector = getSizeDetector(this.sizeDetectBoxCache);
  }

  componentWillUnmount() {
    document.body.removeChild(this.sizeDetectBox);
    this.sizeDetectBoxCache = {};
  }

  componentDidUpdate(prevProps: VTreeViewProps): void {
    if (this.props.isForceOpen !== prevProps.isForceOpen && this.treeRef.current) {
      this.treeRef.current.recomputeTree({
        refreshNodes: true,
        useDefaultOpenness: true,
      });
    }
  }

  render() {
    const { data: items, container } = this.props;

    if (!items || !items.length || this.sizeDetectBox === undefined) {
      return <div />;
    }
    const walker = getWalker(this.props, this.sizeDetectBox, this.sizeDetector);

    // TODO: https://st.yandex-team.ru/CRM-11290 fix types
    /* eslint-disable  @typescript-eslint/no-explicit-any */
    return (
      <div>
        <VariableSizeTree<DataFromWalker>
          ref={this.treeRef}
          treeWalker={walker as any}
          height={container.height}
        >
          {TreeNode}
        </VariableSizeTree>
      </div>
    );
  }
}
