export interface TreeNodeType {
  available: boolean;
  forRequest: boolean;
  fullName: string;
  fullPath: string;
  hasReasons: boolean;
  id: string;
  isLeaf: boolean;
  isReason: boolean;
  name: string;
  top: boolean;
  items?: TreeNodeType[];
  type?: number;
  availability?: number;
  select: number[];
  counter?: { total: number } | null;
}

export interface VTreeViewCommonProps {
  isForceOpen: boolean;
  canSelectAll: boolean;
  selectedId: number;
  currentId: number;
  onItemClick: (item: TreeNodeType) => void;
}

export interface VTreeViewProps extends VTreeViewCommonProps {
  data?: TreeNodeType[];
  itemCount: number;
  parentPath?: string;
  container: { height: number; width: number };
}
