import { PADDING_SIZE } from '../../VTreeView.constants';

const getFlags = ({ selectedId, currentId, canSelectAll, isForceOpen }, item) => {
  const isSelect = selectedId === item.id;
  const isCurrent = currentId === item.id;
  const isUnavailable = item.type === 1 && item.availability === 0;
  const flags = {
    isUnavailable,
    isCurrent,
    isSelect,
    canSelectAll,
    isForceOpen,
  };
  return flags;
};

export default (props, sizeDetectBox, sizeDetector) => {
  const {
    data: tree,
    isForceOpen,
    onItemClick,
    selectedId,
    currentId,
    canSelectAll,
    container,
  } = props;
  return function* treeWalker(refresh) {
    const stack = tree.map((node) => ({ nestingLevel: 0, node })).reverse();
    const fullWidth = container.width - PADDING_SIZE;
    while (stack.length !== 0) {
      const { node: item, nestingLevel } = stack.pop();
      const items = item.items || [];
      const isLeaf = items.length === 0;
      item.fullPath = item.fullName;
      const flags = getFlags({ selectedId, canSelectAll, isForceOpen, currentId }, item);
      let itemWidth = fullWidth - (nestingLevel + 1) * PADDING_SIZE;

      const defaultHeight = sizeDetector(
        sizeDetectBox,
        item.name,
        itemWidth,
        flags.isUnavailable,
        isLeaf,
      );
      const isOpened = yield refresh
        ? {
            defaultHeight,
            height: defaultHeight,
            item,
            isLeaf,
            isOpenByDefault: isForceOpen || nestingLevel === 0,
            id: String(item.id),
            nestingLevel,
            onItemClick,
            selectedId,
            currentId,
            flags,
            width: itemWidth,
          }
        : String(item.id);

      if (items.length !== 0 && isOpened) {
        for (let i = items.length - 1; i >= 0; i--) {
          stack.push({
            nestingLevel: nestingLevel + 1,
            node: items[i],
          });
        }
      }
    }
  };
};
