import { PADDING_SIZE, VERTICAL_PADDING } from '../VTreeView.constants';

export type SizeDetector = (
  sizeDetectBox: HTMLDivElement,
  name: string,
  width: number,
  isUnavailable?: boolean,
  isLeaf?: boolean,
) => number;

export type SizeDetectorCache = Record<string, number>;

export const getSizeDetector = (cache: SizeDetectorCache): SizeDetector => {
  return (
    sizeDetectBox: HTMLDivElement,
    name: string,
    width: number,
    isUnavailable: boolean = false,
    isLeaf: boolean = false,
  ): number => {
    const key = `${name}${width}${isUnavailable}${isLeaf}`;
    if (cache.hasOwnProperty(key)) {
      return cache[key];
    }
    let finalWidth = width - PADDING_SIZE;

    if (isUnavailable && isLeaf) {
      finalWidth -= PADDING_SIZE;
    }
    sizeDetectBox.style.width = `${finalWidth}px`;
    sizeDetectBox.innerText = name;
    cache[key] = sizeDetectBox.offsetHeight + VERTICAL_PADDING;
    return cache[key];
  };
};

export default getSizeDetector;
