import React from 'react';
import cx from 'classnames';
import RouterLink from 'components/RouterLink';
import { VerticalNavigationMenuProps } from './VerticalNavigationMenu.types';

import css from './VerticalNavigationMenu.module.css';

export const VerticalNavigationMenu: React.FC<VerticalNavigationMenuProps> = (props) => {
  const { match, items, className, beforeComponent } = props;

  return (
    <div className={cx(css.VerticalNavigationMenu, className)}>
      {beforeComponent}
      <div className={css.VerticalNavigationMenu__list}>
        {items.map((rule) => (
          <RouterLink
            key={rule.value}
            className={css.VerticalNavigationMenu__item}
            activeClassName={css.VerticalNavigationMenu__item_active}
            to={`${match.url}/${rule.value}`}
          >
            {rule.title}
          </RouterLink>
        ))}
      </div>
    </div>
  );
};
