import { observer } from 'mobx-react-lite';
import { VirtualListService } from 'types/VirtualList';
import { AsyncTaskState } from 'types/AsyncTaskState';
import { AsyncTaskStatus } from 'types/AsyncTaskStatus';
import React, { useContext } from 'react';
import { VirtualListServiceContext } from '../context/VirtualListServiceContext';
import { Loader } from '../Loader';
import { ErrorWithRetry } from '../ErrorWithRetry';

export interface CreateEdgeLoaderComponentOptions {
  isShow: (listService: VirtualListService) => boolean;
  testId: string;
  getAsyncTask: (listService: VirtualListService) => AsyncTaskState;
  getClickHandler: (listService: VirtualListService) => () => void;
}

export const createEdgeLoaderComponent = ({
  testId,
  isShow,
  getAsyncTask,
  getClickHandler,
}: CreateEdgeLoaderComponentOptions) => {
  return observer(() => {
    const listService = useContext(VirtualListServiceContext);

    if (!isShow(listService)) {
      return null;
    }

    const asyncTask = getAsyncTask(listService);
    const handleClick = getClickHandler(listService);

    if (asyncTask.status === AsyncTaskStatus.Error) {
      return (
        <ErrorWithRetry
          error={asyncTask.error || new Error('Неизвестная ошибка')}
          onRetry={handleClick}
        />
      );
    }

    return <Loader data-testid={testId} />;
  });
};
