import { NEXT_SPINNER_TEST_ID, PREVIOUS_SPINNER_TEST_ID } from '../VirtualList.config';
import { createEdgeLoaderComponent } from './createEdgeLoaderComponent';

export const PreviousLoader = createEdgeLoaderComponent({
  isShow: (listService) => listService.hasMorePrevious,
  testId: PREVIOUS_SPINNER_TEST_ID,
  getAsyncTask: (listService) => listService.loadPreviousTask,
  getClickHandler: (listService) => listService.retryLoadPrevious,
});

export const NextLoader = createEdgeLoaderComponent({
  isShow: (listService) => listService.hasMoreNext,
  testId: NEXT_SPINNER_TEST_ID,
  getAsyncTask: (listService) => listService.loadNextTask,
  getClickHandler: (listService) => listService.retryLoadNext,
});
