import React, { FC } from 'react';
import { ErrorBlock } from 'components/ErrorBlock';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import css from './ErrorWithRetry.module.css';
import { ErrorWithRetryProps } from './ErrorWithRetry.types';

export const ErrorWithRetry: FC<ErrorWithRetryProps> = ({
  className,
  error,
  onRetry,
  view = 'row',
  ...other
}) => (
  <div className={cx(css.ErrorWithRetry, className, css[`ErrorWithRetry_view_${view}`])} {...other}>
    <div className={css.ErrorWithRetry__content}>
      <ErrorBlock error={error} />
      <Button size="s" onClick={onRetry}>
        Повторить
      </Button>
    </div>
  </div>
);
