import React, { Ref, useContext } from 'react';
import cx from 'classnames';
import css from './ListWrapper.module.css';
import { VirtualListUIContext } from '../context';

export const ListWrapper = React.forwardRef((props, ref: Ref<HTMLDivElement>) => {
  const { isScrolling } = useContext(VirtualListUIContext);

  return (
    <div className={cx({ [css.ListWrapper_disableHover]: isScrolling })} {...props} ref={ref} />
  );
});
