import React, { FC, HTMLAttributes } from 'react';
import Spin from '@crm/components/dist/lego2/Spin';
import cx from 'classnames';
import css from './Loader.module.css';

export const Loader: FC<HTMLAttributes<HTMLDivElement>> = ({ className, ...other }) => (
  <div className={cx(css.Loader, className)} {...other}>
    <Spin progress view="default" size="m" />
  </div>
);
