import React from 'react';
import { observer } from 'mobx-react-lite';
import { VirtualList } from './VirtualList';
import { VirtualListServiceStub, CommentVirtualListItem } from './VirtualListService.stub';

export default {
  title: 'VirtualList',
};

const virtualListServiceStub = new VirtualListServiceStub(10000);

const Item = observer(({ item }: { item: CommentVirtualListItem }) => {
  if (!item) {
    return null;
  }

  return (
    <div style={{ padding: 20, wordBreak: 'break-all' }}>
      <div>{item.id}</div>
      <div>{item.text}</div>
    </div>
  );
});

const renderItemContent = (item: CommentVirtualListItem) => <Item item={item} />;

export const Default = () => {
  return (
    <VirtualList
      style={{ height: 600, width: 600 }}
      listService={virtualListServiceStub}
      itemContent={renderItemContent}
    />
  );
};
