import { VirtualListService, VirtualListItem } from 'types/VirtualList';
import { AsyncTaskStatus } from 'types/AsyncTaskStatus';
import { AsyncTaskState } from 'types/AsyncTaskState';

export interface CommentVirtualListItem extends VirtualListItem {
  text: string;
}

export class VirtualListServiceStub implements VirtualListService<CommentVirtualListItem> {
  firstItemIndex = 0;
  hasMoreNext = false;
  hasMorePrevious = false;
  initialTopMostItemIndex: number;

  loadInitTask: AsyncTaskState = { status: AsyncTaskStatus.Complete, data: undefined };
  loadNextTask: AsyncTaskState = { status: AsyncTaskStatus.Idle, data: undefined };
  loadPreviousTask: AsyncTaskState = { status: AsyncTaskStatus.Idle, data: undefined };

  private readonly items: CommentVirtualListItem[];

  constructor(public readonly length = 10) {
    this.initialTopMostItemIndex = length - 1;

    this.items = Array(length)
      .fill(1)
      .map((_, index) => ({
        id: index + 1,
        seqId: index,
        prevId: index,
        text: `Comment index: ${index}`,
        etype: 'OComment',
      }));
  }

  appendNonOrderItems(_items: VirtualListItem[]): void {}

  destroy(): void {}

  endReached(_index: number): void {}

  hasItemByAbsoluteIndex(index) {
    return Boolean(this.items[index]);
  }

  getItemByAbsoluteIndex(index) {
    return this.items[index];
  }

  getItemIdByAbsoluteIndex(index) {
    return this.items[index].id;
  }

  init() {}

  startReached() {}

  updateMeta() {}

  retryInit() {}

  retryLoadNext() {}

  retryLoadPrevious() {}

  handleScroll() {}
}
