import React, { useState, useCallback } from 'react';
import { WikiFormatterProps } from './WikiFormatter.types';

let resolvePromise;
const promise = new Promise((resolve) => {
  resolvePromise = resolve;
});

const Waiter = React.lazy(() =>
  promise.then(() => ({
    default: (() => null) as React.ComponentType,
  })),
);

export const withWFLoader = (
  Component: React.ComponentType<WikiFormatterProps>,
): React.ComponentType<WikiFormatterProps> => {
  const WithWF = (props) => {
    const [loaded, setLoaded] = useState(false);
    const onContentUpdatedCb = useCallback(
      loaded
        ? props.onContentUpdated
        : () => {
            resolvePromise();
            setLoaded(true);
            props.onContentUpdated?.();
          },
      [loaded, props.onContentUpdated],
    );

    return (
      <>
        <Waiter />
        <Component {...props} onContentUpdated={onContentUpdatedCb} />
      </>
    );
  };

  return WithWF;
};
