import React, { Suspense } from 'react';
import { storiesOf } from '@storybook/react';
import { Form, Field } from 'react-final-form';
import WikiFormatter from './WikiFormatter';

const onSubmit = () => {};

const WikiFormatterStories = () => {
  return (
    <Form
      onSubmit={onSubmit}
      initialValues={{ input: '**Hello**' }}
      subscription={{ values: true }}
    >
      {({ handleSubmit, values: { input } }) => {
        return (
          <form onSubmit={handleSubmit}>
            <style>
              {`
                .wikiFormatter {
                  border: 1px solid grey;
                }
              `}
            </style>
            <Field component="input" name="input" />
            <Suspense fallback={<div>Loading...</div>}>
              <WikiFormatter className="wikiFormatter" markdown={input} />
            </Suspense>
          </form>
        );
      }}
    </Form>
  );
};

storiesOf('WikiFormatterV2', module).add('WikiFormatter', WikiFormatterStories);
