import React from 'react';
import cx from 'classnames';
import { WikiFormatter } from '@yandex-int/tools-components/WikiFormatter';
import { YfmFormatter } from 'components/YfmFormatter';
import { config } from 'services/Config';
import css from './WikiFormatter.module.css';
import { WikiFormatterProps } from './WikiFormatter.types';
import { withWFLoader } from './Loader';
import { getSettings } from './WikiFormatter.utils';

const WikiFormatterBase: React.FC<WikiFormatterProps> = ({ markdown, className, ...props }) => {
  const componentClassName = cx(css.root, className);


  if (config.value.features.useYfm) {
    return <YfmFormatter markdown={markdown} className={className} {...props} />;
  }

  const settings = getSettings();

  return (
    <WikiFormatter
      nonce={settings.nonce}
      settings={settings.settings}
      className={componentClassName}
      {...props}
    >
      {markdown}
    </WikiFormatter>
  );
};

export default withWFLoader(WikiFormatterBase);