import getCrmConfig from 'entry/utils/getCrmConfig';
import { config } from 'services/Config';
import { GetSettingsResult } from './WikiFormatter.types';

let settings: GetSettingsResult | null = null;

export const getSettings = (): GetSettingsResult => {
  if (settings) {
    return settings;
  }

  settings = {
    nonce: getCrmConfig()?.nonce ?? '',
    settings: {
      lang: 'en',
      instance: 'intranet',
      remark: {
        woofmd: {
          actions: [{ name: 'iframe' }, { name: 'forms' }],
        },
      },
    },
  };

  if (process.env.NODE_ENV === 'production') {
    settings.settings!.wfaasUrl = '/wfaas';
  }

  return settings;
};
