import React, { Suspense } from 'react';

export const withSuspense = (WrappedComponent) => (props) => (
  <Suspense fallback={<span />}>
    <WrappedComponent {...props} />
  </Suspense>
);
