import React from 'react';
import cx from 'classnames';
import css from './WordBreak.module.css';

interface WordBreakProps extends React.HTMLAttributes<HTMLElement> {
  as?: 'div' | 'span';
}

const WordBreak: React.FC<WordBreakProps> = props => {
  const { as: Component = 'div', className, ...other } = props;

  return <Component className={cx(className, css.wordBreak)} {...other} />;
};

export default WordBreak;
